#!/bin/bash
#
# Install Skript für do_borgbackup
#
# Syntax:
# install_borg.sh
#  -h                 (help)
#  -u <user>
#  -g <group>
#
#------------------------------------------------------------
# History (last entry on top)
#
# 03.09.2020 hk   RESULTFILE => LOG_FILE
#                 Home-Verzeichnis des Users aus /etc/passwd holen
# 02.09.2020 hk   merge mit DH-Version
#                 kopf und show wieder raus => zu viele Ausgaben
#                 logger wieder raus => Ausgabe in logfile reicht
#            dh   Überarbeitung mit erweiterten functions und Benutzerführung
# 01.09.2020 hk   erste Version
#
# ToDo:
# -
#

VERSION="2.0-20200903"                           # diese Info könnte man sich ggf. auch aus do_borgbackup holen
USER="dummy"
GROUP="dummy"

LOG_DIR="/tmp/install_borg"                      # Verzeichnis für alle log-Infos
LOG_FILE="${LOG_DIR}/install_borgBackup.log"

LINIE="----------------------------------------"

BASEDIR=${0%/*}                                  # den Aufrufpfad des laufenden Skripts extrahieren
if [[ "${BASEDIR}" != /* ]]
  then
    # Umstellen auf absoluten Pfad, damit die Verwendung unabhängig vom aktuellen Pfad klappt.
    BASEDIR="${PWD}/${BASEDIR}"
  fi
PRE_POST_DIR="${BASEDIR}/borgbackup"             # Verzeichnis für alle Hilfsfiles

function exit_on_error () {
  echo -e "${1}\n${LINIE}" >> ${LOG_FILE}
  cat ${LOG_FILE}
  exit 2
  }

function prompt_text () {                        # Benutzereingabe abholen
  local aa
  read -p "${1} " text
  if [ ${#text} -eq 0 ] ; then
    aa="dummy"
  else
    aa=${text}
  fi
  echo "${aa}"
}

#----------------------------------------Main----------------------------------------
mkdir -p "${LOG_DIR}"                            # LOG_DIR anlegen
echo -e "Installation of do_borgbackup (${VERSION}) at $(date) \n${LINIE}" > ${LOG_FILE}

if [ ${UID} != 0 ] || [ `id -g` != 0 ]
  then
    exit_on_error "System-Operation without root access not possible $(date) "
  fi

# cmdline Parameter-Analyse
npar=0
res=0
if  [ $# -gt 1 ]
  then
    while getopts "hu:g:" opt
      do
        case $opt in
          h) exit_on_error "The script expects as parameter USER and GROUP for use with do_borgbackup"
             ;;
          u) USER=${OPTARG}
             (( npar += 1 ))
            ;;
          g) GROUP=${OPTARG}
             (( npar += 1 ))
            ;;
          ?) echo "unknown option ${opt} arg=${OPTARG}" >> ${LOG_FILE}
            res=1
            ;;
        esac
      echo "  ${opt} = ${OPTARG} " >> ${LOG_FILE}
      done
    if [ ${res} -eq 1 -o ${npar} -lt 2 ]
      then
        exit_on_error "cmdline check failed! Valide parameters: ${npar}"
      fi
  fi

# User anfordern und mit /etc/passswd abgleichen
if [ ${USER} = "dummy" ]
  then
    cnt=0
    n=0
    while [[ ${cnt} -lt 1 ]]
      do
        (( n += 1 ))
        USER=$(prompt_text  "User for do_borgbackup: " "dummy")
        cnt=$(grep -c -e "^${USER}" /etc/passwd)                          # liefert 1 bei vorh. 0 bei nix
        if [ ${n} -gt  3 ]                                                # nach 3 Fehleingaben Programm beenden
	  then
	    exit_on_error "${n}. try! User does not exist"                # Abbruch, hoffnungsloser Fall
	  fi
      done
  fi

# GROUP anfordern und mit /etc/group abgleichen
if [ ${GROUP} = "dummy" ]
  then
    cnt=0
    n=0
    while [[ ${cnt} -lt 1 ]]
      do
        (( n += 1 ))
        GROUP=$(prompt_text  "GROUP for do_borgbackup: " "dummy")
        cnt=$(grep -c -e "^${GROUP}" /etc/group)                          # liefert 1 bei vorh. 0 bei nix
        if [ ${n} -gt  3 ]                                                # nach 3 Fehleingaben Programm beenden
	  then
	    exit_on_error "${n}. try! Group does not exist"               # Abbruch, hoffnungsloser Fall
	  fi
      done
  fi
echo -e "user=${USER}  group=${GROUP}\n${LINIE}" >> ${LOG_FILE}

# install nach USER
USER_HOME="$(grep "^${USER}" | cut -f6 -d ":")"  # echtes Home-Verzeichnis des Systems holen
if [ -d ${USER_HOME}/bin ]                       # check if ~/bin available
  then
    USER_ZIEL="${HOME_USER}/bin"
  else
    # Nach Bedarf /home/${USER}/bin anlegen und in PATH einbauen
    USER_ZIEL="${HOME_USER}"
  fi
PRE_POST_USER_ZIEL=${USER_ZIEL}/borgbackup
echo "install scripts to ${USER_ZIEL}" >> ${LOG_FILE}

cp ${BASEDIR}/do_borgbackup ${USER_ZIEL}; chown ${USER}:${GROUP} ${USER_ZIEL}/do_borgbackup
mkdir -p ${PRE_POST_USER_ZIEL}
cp ${PRE_POST_DIR}/* ${PRE_POST_USER_ZIEL}; chown -R ${USER}:${GROUP} ${PRE_POST_USER_ZIEL}

# links für root
ROOT_HOME="$(grep "^root" | cut -f6 -d ":")"     # echtes Home-Verzeichnis des Systems holen
if [ -d ${ROOT_HOME}/bin ]                       # check if ~/bin available
  then
    ROOT_ZIEL="${ROOT_HOME}/bin"
  else
    # Nach Bedarf /root/bin anlegen und in PATH einbauen
    ROOT_ZIEL="${ROOT_HOME}"
  fi
PRE_POST_ROOT_ZIEL=${ROOT_ZIEL}/borgbackup
echo "install root-links in ${ROOT_ZIEL}" >> ${LOG_FILE}

ln -s ${USER_ZIEL}/do_borgbackup ${ROOT_ZIEL}/do_borgbackup

# Hier werden aktuell nur die Links für die Systemssicherung angelegt.
# Sind auch Datensicherung als root-User gewünscht, so müssen die dafür benötigten
# pre-/post-Skript-Links noch hinzugefügt werden.
mkdir -p ${PRE_POST_ROOT_ZIEL}
ln -s ${PRE_POST_USER_ZIEL}/borg_cmd_parameter    ${PRE_POST_ROOT_ZIEL}/borg_cmd_parameter
ln -s ${PRE_POST_USER_ZIEL}/post_create_sys_btrfs ${PRE_POST_ROOT_ZIEL}/post_create_sys_btrfs
ln -s ${PRE_POST_USER_ZIEL}/post_error_btrfs      ${PRE_POST_ROOT_ZIEL}/post_error_btrfs
ln -s ${PRE_POST_USER_ZIEL}/pre_create_data       ${PRE_POST_ROOT_ZIEL}/pre_create_data
ln -s ${PRE_POST_USER_ZIEL}/pre_create_sys_btrfs  ${PRE_POST_ROOT_ZIEL}/pre_create_sys_btrfs
ln -s ${PRE_POST_USER_ZIEL}/pre_create_sys_efi    ${PRE_POST_ROOT_ZIEL}/pre_create_sys_efi
echo -e "      further links as necessary\n${LINIE}" >> ${LOG_FILE}

# /etc/borgbackup bestücken
mkdir -p /etc/borgbackup
cp ${BASEDIR}/borg_Doku/etc/borgbackup/borg* /etc/borgbackup
cp ${BASEDIR}/borg_Doku/etc/borgbackup/*_exclude /etc/borgbackup
chown -R ${USER}:${GROUP} /etc/borgbackup

# FUSE_POINT anlegen
echo "ToDo: The directory FUSE_POINT has to be generated and equipped with the appropriate USER/GROUP values" >> ${LOG_FILE}
# mkdir /media/borg_fuse
# chown ${USER}:${GROUP} /media/borg_fuse 

# ssh-key für remote-backup generieren
echo "ToDo: ssh-key for remote-backup" >> ${LOG_FILE}
# ssh-keygen
echo -e "ToDo: test ssh-login to remote-backup\n${LINIE}" >> ${LOG_FILE}
# ssh <remote-user>@<remote-server>

# ZIEL anlegen
echo "ToDo: The destination directory for the borg repository has to be created with the appropriate USER/GROUP values" >> ${LOG_FILE}
# mkdir /borg
# chown $[USER}:${GROUP} /borg

echo -e "Borg-Backup install finished at `date`\n${LINIE}" >> ${LOG_FILE}

echo
cat ${LOG_FILE}                                  # Log-File-Ausgabe nach Bedarf

#rm -rf "${LOG_DIR}"                              # aufräumen
